//sprite.c
//An example showing 3 sprites

library "PToolboxLib"

//Fake out data struct with macros
#define .x [0]
#define .y [1]
#define .cmd [2]
#define .bitmap [3]
#define .mask [4]
#define .buffer [5]
#define .callback [6]
#define .colmask[7]
#define .x_move [8]
#define .y_move [9]

pointer data;

//define a sprite handler function
move(int id, int ptr) {
    if(ptr.x<0 || ptr.x>144) {
      ptr.x_move = -ptr.x_move;
      ptr.x = ptr.x + ptr.x_move;
    }
    if(ptr.y<0 || ptr.y>144) {
      ptr.y_move = -ptr.y_move;
      data.y = data.y + ptr.y_move;
    }  
}

main() {

int i,j,t,p;
data = Array("i,3,12");
p=data[0];

if(!dbtotalsize("test_bitmap")) {
  alert("Failed to find test_bitmap.prc!");
  return;
}
OpenBmpDb("test_bitmap");

//Set Depth
i=getsd("Enter Screen Depth (1,2,4, or 8)","1");
if(SetDepth(i)==0) {
  alert("Depth not supported on device/OS");
  return;
}

graph_on();

//Setup buffers
ClearBuf();
line(1,0,40,160,40);
line(1,0,120,160,120);
line(1,40,0,40,160);
line(1,120,0,120,160);

//Setup sprite array

//sprite #1
data[0].x = 40; //X-pos
data[0].y = 40; //Y-pos
data[0].cmd = 1; //command = initialize
data[0].bitmap = 5;  //bitmap index
data[0].mask = 5;  //mask index
data[0].buffer = 3;  //scratch buf index
data[0].callback = move; //movement handler function
data[0].colmask = 1; //collision mask
data[0].x_move = 1; //X-movement vector
data[0].y_move = 1; //Y-movement vector

//sprite #2    
data[1].x = 120; //X-pos
data[1].y = 40;  //Y=pos
data[1].cmd = 1; //command = initialize
data[1].bitmap = 5;  //bitmap index
data[1].mask = 5;    //mask index
data[1].buffer = 4;  //scratch buf index
data[1].callback = move; //movement handler function
data[1].colmask = 1; //collision mask
data[1].x_move = -1; //X-movement vector
data[1].y_move = 1;  //Y-movement vector

//sprite #3  
data[2].x = 40;  //X-pos
data[2].y = 120; //Y-pos
data[2].cmd = 1; //command = initialize
data[2].bitmap = 5; //bitmap index
data[2].mask = 5;   //mask index
data[2].buffer = 5; //scratch buf index
data[2].callback = move; //movement handler function
data[2].colmask = 1; //collision mask
data[2].x_move = 1;  //X-movement vector
data[2].y_move = 0; //Y-movement vector

i=500;
t=ticks();
while(i--) {
  Sprite(3,p);
  j=SpriteRectColl(0,3,p);
  if(j!=-1) {
    text(10,10,j);
  }
}
puts("TIME="+(ticks()-t)+"\n");
event(1);
graph_off();
SetDepth(0);
}